﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ExpHeapAllocator.h> // for nn::sf::ExpHeapStaticAllocator
#include <nn/nn_Abort.h>

#include <nn/nfc/am/detail/nfc_AmPort.h>
#include <nn/nfc/am/detail/nfc_IAm.h>    // for IAm
#ifdef NN_NFC_AM_BUILD_CONFIG_DIRECT_FUNCTION_CALL
#include <nn/nfc/am/server/nfc_CreateAmManagerByDfc.h>
#endif

namespace nn { namespace nfc { namespace am { namespace client {

namespace {

#ifndef NN_NFC_AM_BUILD_CONFIG_DIRECT_FUNCTION_CALL
// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct CreateAmManagerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateAmManagerByHipcTag> AmAllocator;

nn::sf::HipcSimpleClientSessionManager g_AmDomain;

// MyAllocator を静的コンストラクタで初期化するためのヘルパー
class AmAllocatorInitializer
{
public:

    AmAllocatorInitializer() NN_NOEXCEPT
    {
        AmAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_AmAllocatorInitializer;

nn::sf::SharedPointer<nn::nfc::am::detail::IAmManager> CreateAmManagerByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::nfc::am::detail::IAmManager> pAccessor;
    auto result = g_AmDomain.InitializeByName<nn::nfc::am::detail::IAmManager, AmAllocator::Policy>(&pAccessor, nn::nfc::am::detail::AmPortName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_AmDomain.SetSessionCount(nn::nfc::am::detail::AmSessionCount));
    NN_SDK_ASSERT(pAccessor);
    return pAccessor;
}
#endif

nn::sf::SharedPointer<nn::nfc::am::detail::IAm> g_RefAmInterface = nullptr;

}

void CreateAmInterface() NN_NOEXCEPT
{
#ifndef NN_NFC_AM_BUILD_CONFIG_DIRECT_FUNCTION_CALL
    auto pAccessor = CreateAmManagerByHipc();
#else
    auto pAccessor = nn::nfc::am::server::CreateAmManagerByDfc();
#endif
    pAccessor->CreateAmInterface(&g_RefAmInterface);
    NN_SDK_ASSERT(g_RefAmInterface);
    pAccessor = nullptr;
}

nn::sf::SharedPointer<nn::nfc::am::detail::IAm>GetAmInterface() NN_NOEXCEPT
{
    NN_SDK_REQUIRES(g_RefAmInterface != nullptr, "nfcAm ライブラリは初期化されていません。");
    return g_RefAmInterface;
}

void DestroyAmInterface() NN_NOEXCEPT
{
    g_RefAmInterface = nullptr;
#ifndef NN_NFC_AM_BUILD_CONFIG_DIRECT_FUNCTION_CALL
    g_AmDomain.Finalize();
#endif
}

bool IsCreatedAmInterface() NN_NOEXCEPT
{
    return (g_RefAmInterface != nullptr);
}

}}}}
