﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn
{
    [CppRefPath(@"<nn/nn_ApplicationId.h>")]
    [ExternalStruct(8, 8)]
    public struct ApplicationId
    {
    }
}

namespace nn.news
{
    [CppRefPath(@"<nn/news/news_TypesAdmin.h>")]
    [ExternalStruct(24, 1)]
    public struct NewsId
    {
    }

    [CppRefPath(@"<nn/news/news_TypesAdmin.h>")]
    [ExternalStruct(24, 1)]
    public struct UserId
    {
    }

    [CppRefPath(@"<nn/news/news_TypesAdmin.h>")]
    [ExternalStruct(32, 1)]
    public struct TopicId
    {
    }

    [CppRefPath(@"<nn/news/news_TypesAdmin.h>")]
    [ExternalStruct(128, 8)]
    public struct NewsRecord
    {
    }

    [CppRefPath(@"<nn/news/news_TypesAdmin.h>")]
    [ExternalStruct(72, 8)]
    public struct NewsRecordV1
    {
    }
}

namespace nn.news.detail.ipc
{
    [CppRefPath(@"<nn/news/detail/ipc/news_INewlyArrivedEventHolder.sfdl.h>")]
    public interface INewlyArrivedEventHolder : IServiceObject
    {
        [MethodId(0)]
        Result Get(Out<NativeHandle> outHandle);
    }
}

namespace nn.news.detail.ipc
{
    [CppRefPath(@"<nn/news/detail/ipc/news_IOverwriteEventHolder.sfdl.h>")]
    public interface IOverwriteEventHolder : IServiceObject
    {
        [MethodId(0)]
        Result Get(Out<NativeHandle> outHandle);
    }
}

namespace nn.news.detail.ipc
{
    [CppRefPath(@"<nn/news/detail/ipc/news_INewsDataService.sfdl.h>")]
    public interface INewsDataService : IServiceObject
    {
        [MethodId(0)]
        Result Open(InArray<char_t> name);

        [MethodId(1001)]
        Result OpenWithNewsRecord(NewsRecord record);

        // バイナリ互換性維持のため、残しておく。
        [MethodId(1)]
        Result OpenWithNewsRecordV1(NewsRecordV1 record);

        [MethodId(2)]
        Result Read(Out<uint64_t> outSize,
            int64_t offset, [BufferTransferMode(BufferTransferMode.MapAlias)] OutBuffer buffer);

        [MethodId(3)]
        Result GetSize(Out<int64_t> outSize);

        // [MethodId(1001)]
        // Result OpenWithNewsRecord(NewsRecord record);
    }
}

namespace nn.news.detail.ipc
{
    [CppRefPath(@"<nn/news/detail/ipc/news_INewsDatabaseService.sfdl.h>")]
    public interface INewsDatabaseService : IServiceObject
    {
        [MethodId(1000)]
        Result GetList(Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<NewsRecord> outRecords,
            InArray<char_t> wherePhrase, InArray<char_t> orderByPhrase, int32_t offset);

        // バイナリ互換性維持のため、残しておく。
        [MethodId(0)]
        Result GetListV1(Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<NewsRecordV1> outRecords,
            InArray<char_t> wherePhrase, InArray<char_t> orderByPhrase, int32_t offset);

        [MethodId(1)]
        Result Count(Out<int32_t> outCount,
            InArray<char_t> wherePhrase);

        [MethodId(2)]
        Result CountWithKey(Out<int32_t> outCount,
            bool distinct, InArray<char_t> key, InArray<char_t> wherePhrase);

        [MethodId(3)]
        Result UpdateIntegerValue(InArray<char_t> key, int32_t value, InArray<char_t> wherePhrase);

        [MethodId(4)]
        Result UpdateIntegerValueWithAddition(InArray<char_t> key, int32_t value, InArray<char_t> wherePhrase);

        [MethodId(5)]
        Result UpdateStringValue(InArray<char_t> key, InArray<char_t> value, InArray<char_t> wherePhrase);

        // [MethodId(1000)]
        // Result GetList(Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<NewsRecord> outRecords,
        //     InArray<char_t> wherePhrase, InArray<char_t> orderByPhrase, int32_t offset);
    }
}

namespace nn.news.detail.ipc
{
    [CppRefPath(@"<nn/news/detail/ipc/news_INewsService.sfdl.h>")]
    public partial interface INewsService : IServiceObject {}

    ////////////////////////////////////////////////////////////////////////////////
    // Post API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface INewsService : IServiceObject
    {
        [MethodId(10100)]
        Result PostLocalNews([BufferTransferMode(BufferTransferMode.MapAlias)] InBuffer data);
    }

    ////////////////////////////////////////////////////////////////////////////////
    // Configuration API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface INewsService : IServiceObject
    {
        [MethodId(20100)]
        Result SetPassphrase(ApplicationId appId, InArray<char_t> passphrase);
    }

    ////////////////////////////////////////////////////////////////////////////////
    // Viewer API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface INewsService : IServiceObject
    {
        [MethodId(30100)]
        Result GetSubscriptionStatus(Out<int32_t> outStatus, InArray<char_t> topicIdString);

        [MethodId(30101)]
        Result GetTopicList(Out<int32_t> outCount,
            [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<TopicId> outTopicIds, int32_t filter);

        [MethodId(30200)]
        Result IsSystemUpdateRequired(Out<bool> outIsRequired);

        [MethodId(30300)]
        Result RequestImmediateReception(InArray<char_t> topicIdString);

        [MethodId(30400)]
        Result DecodeArchiveFile(Out<uint64_t> outSize, [BufferTransferMode(BufferTransferMode.MapAlias)] OutBuffer decoded,
            [BufferTransferMode(BufferTransferMode.MapAlias)] InBuffer encoded);
    }

    ////////////////////////////////////////////////////////////////////////////////
    // Manager API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface INewsService : IServiceObject
    {
        [MethodId(40100)]
        Result SetSubscriptionStatus(InArray<char_t> topicIdString, int32_t status);

        [MethodId(40101)]
        Result RequestAutoSubscription(ApplicationId appId);

        [MethodId(40200)]
        Result ClearStorage();

        [MethodId(40201)]
        Result ClearSubscriptionStatusAll();
    }

    ////////////////////////////////////////////////////////////////////////////////
    // Debug API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface INewsService : IServiceObject
    {
        [MethodId(90100)]
        Result GetNewsDatabaseDump(Out<uint64_t> outSize,
            [BufferTransferMode(BufferTransferMode.MapAlias)] OutBuffer buffer);
    }
}

namespace nn.news.detail.ipc
{
    [CppRefPath(@"<nn/news/detail/ipc/news_IServiceCreator.sfdl.h>")]
    public interface IServiceCreator : IServiceObject
    {
        [MethodId(0)]
        Result CreateNewsService(Out<INewsService> outService);

        [MethodId(1)]
        Result CreateNewlyArrivedEventHolder(Out<INewlyArrivedEventHolder> outHolder);

        [MethodId(4)]
        Result CreateOverwriteEventHolder(Out<IOverwriteEventHolder> outHolder);

        [MethodId(2)]
        Result CreateNewsDataService(Out<INewsDataService> outService);

        [MethodId(3)]
        Result CreateNewsDatabaseService(Out<INewsDatabaseService> outService);

        // [MethodId(4)]
        // Result CreateOverwriteEventHolder(Out<IOverwriteEventHolder> outHolder);
    }
}
