﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/news/detail/service/news_NewsDataService.generic.h>
#include <nn/news/news_Result.h>

namespace nn { namespace news { namespace detail { namespace service {

NewsDataServiceForGeneric::NewsDataServiceForGeneric() NN_NOEXCEPT :
    m_IsOpened(false)
{
}

NewsDataServiceForGeneric::~NewsDataServiceForGeneric() NN_NOEXCEPT
{
    if (m_IsOpened)
    {
        nn::fs::CloseFile(m_Handle);
    }
}

nn::Result NewsDataServiceForGeneric::Open(const nn::sf::InArray<char>& name) NN_NOEXCEPT
{
    NN_UNUSED(name);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result NewsDataServiceForGeneric::OpenWithNewsRecord(const nn::news::NewsRecord& record) NN_NOEXCEPT
{
    NN_UNUSED(record);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result NewsDataServiceForGeneric::OpenWithNewsRecordV1(const nn::news::NewsRecordV1& record) NN_NOEXCEPT
{
    NN_UNUSED(record);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result NewsDataServiceForGeneric::Read(nn::sf::Out<std::uint64_t> outSize, std::int64_t offset, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
{
    NN_UNUSED(outSize);
    NN_UNUSED(offset);
    NN_UNUSED(buffer);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result NewsDataServiceForGeneric::GetSize(nn::sf::Out<std::int64_t> outSize) NN_NOEXCEPT
{
    NN_UNUSED(outSize);

    NN_RESULT_THROW(ResultNotImplemented());
}

}}}}
