﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/news/detail/service/news_NewlyArrivedEventHolder.generic.h>
#include <nn/news/news_Result.h>

namespace nn { namespace news { namespace detail { namespace service {

NewlyArrivedEventHolderForGeneric::NewlyArrivedEventHolderForGeneric() NN_NOEXCEPT :
    m_Event(nn::os::EventClearMode_ManualClear, true)
{
}

NewlyArrivedEventHolderForGeneric::~NewlyArrivedEventHolderForGeneric() NN_NOEXCEPT
{
}

nn::Result NewlyArrivedEventHolderForGeneric::Get(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
{
    outHandle.Set(nn::sf::NativeHandle(m_Event.DetachReadableHandle(), true));

    NN_RESULT_SUCCESS;
}

}}}}
