﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/news/detail/service/core/news_TopicListReader.h>
#include <nn/news/detail/service/msgpack/news_MsgpackReader.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

TopicListReader::TopicListReader() NN_NOEXCEPT :
    m_OutTopicIds(nullptr),
    m_Index(0),
    m_Count(0)
{
}

nn::Result TopicListReader::Read(int* outCount, TopicId* outTopicIds, int count, nne::nlib::InputStream& stream) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outCount);
    NN_SDK_REQUIRES_NOT_NULL(outTopicIds);
    NN_SDK_REQUIRES_GREATER(count, 0);

    m_OutTopicIds = outTopicIds;
    m_Count = count;

    m_Index = 0;

    detail::service::msgpack::MsgpackReader reader;

    NN_RESULT_TRY(reader.Parse(stream, *this, sizeof (TopicId)))
        NN_RESULT_CATCH(ResultAbortedByCallback)
        {
            NN_RESULT_THROW(ResultInvalidFormat());
        }
    NN_RESULT_END_TRY;

    *outCount = m_Index;

    NN_RESULT_SUCCESS;
}

bool TopicListReader::OnString(const detail::service::msgpack::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT
{
    NN_UNUSED(length);
    NN_UNUSED(isOverflowed);

    if (jsonPath.Match("$[*]"))
    {
        if (!StringVerifier::VerifyTopicId(value))
        {
            return false;
        }
        if (m_Index < m_Count)
        {
            nn::util::Strlcpy(m_OutTopicIds[m_Index++].value, value, sizeof (m_OutTopicIds[0].value));
        }
    }

    return true;
}

}}}}}
