﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/news/detail/service/core/news_Path.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

namespace
{
    bool MakeNewsDataPathImpl(char* path, size_t size, const UserId& userId, const NewsId& newsId) NN_NOEXCEPT
    {
        int length = 0;

        if (userId.value[0])
        {
            length = nn::util::SNPrintf(path, size, "news:/data/U%s_%s.msgpack", userId.value, newsId.value);
        }
        else
        {
            length = nn::util::SNPrintf(path, size, "news:/data/D00000000000000000000_%s.msgpack", newsId.value);
        }

        return (static_cast<size_t>(length) + 1 <= size);
    }
}

bool Path::MakeNewsDataPath(char* path, size_t size, const char* name) NN_NOEXCEPT
{
    int length = nn::util::SNPrintf(path, size, "news:/data/%s", name);

    return (static_cast<size_t>(length) + 1 <= size);
}

bool Path::MakeNewsDataPath(char* path, size_t size, const NewsRecord& record) NN_NOEXCEPT
{
    return MakeNewsDataPathImpl(path, size, record.userId, record.newsId);
}

bool Path::MakeNewsDataPath(char* path, size_t size, const NewsRecordV1& record) NN_NOEXCEPT
{
    return MakeNewsDataPathImpl(path, size, record.userId, record.newsId);
}

}}}}}
