﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/news/detail/service/core/news_ForegroundStorageLockManager.h>
#include <nn/news/detail/service/core/news_StorageManager.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

ForegroundStorageLockManager::ForegroundStorageLockManager() NN_NOEXCEPT :
    m_Mutex(true)
{
}

void ForegroundStorageLockManager::AcquireDataAccessorLock() NN_NOEXCEPT
{
    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    bool isFirst = !m_AccessorsImporterLock.IsReadLockHeld();

    m_AccessorsImporterLock.AcquireReadLock();

    if (isFirst)
    {
        StorageManager::GetInstance().Lock();
    }
}

void ForegroundStorageLockManager::ReleaseDataAccessorLock() NN_NOEXCEPT
{
    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    NN_SDK_ASSERT(m_AccessorsImporterLock.IsReadLockHeld());

    m_AccessorsImporterLock.ReleaseReadLock();

    if (!m_AccessorsImporterLock.IsReadLockHeld())
    {
        StorageManager::GetInstance().Unlock();
    }
}

bool ForegroundStorageLockManager::TryAcquireImporterLock() NN_NOEXCEPT
{
    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    if (m_AccessorsImporterLock.IsReadLockHeld())
    {
        return false;
    }

    m_AccessorsImporterLock.AcquireWriteLock();

    StorageManager::GetInstance().Lock();

    return true;
}

void ForegroundStorageLockManager::ReleaseImporterLock() NN_NOEXCEPT
{
    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    NN_SDK_ASSERT(m_AccessorsImporterLock.IsWriteLockHeldByCurrentThread());

    StorageManager::GetInstance().Unlock();

    m_AccessorsImporterLock.ReleaseWriteLock();
}

}}}}}
