﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/news/detail/service/core/news_Account.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

bool Account::IsAvailableNintendoAccountLinked() NN_NOEXCEPT
{
    nn::account::Uid uids[nn::account::UserCountMax] = {};
    int count = 0;

    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::account::ListAllUsers(&count, uids, nn::account::UserCountMax));

    for (int i = 0; i < count; i++)
    {
        nn::account::NetworkServiceAccountManager manager;

        if (nn::account::GetNetworkServiceAccountManager(&manager, uids[i]).IsFailure())
        {
            continue;
        }

        // 2KB あるのでスタックサイズに注意。
        Bit8 buffer[nn::account::RequiredBufferSizeForCachedNintendoAccountInfo] = {};

        nn::account::CachedNintendoAccountInfoForSystemService accountInfo;

        if (manager.LoadCachedNintendoAccountInfo(&accountInfo, buffer, sizeof (buffer)).IsFailure())
        {
            continue;
        }

        return true;
    }

    return false;
}

void Account::GetCountryList(int* outCount, Country* outCountries, int count) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outCount);
    NN_SDK_REQUIRES_NOT_NULL(outCountries);
    NN_SDK_REQUIRES(count > 0);

    int actualCount = 0;

    nn::account::Uid uids[nn::account::UserCountMax] = {};
    int userCount = 0;

    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::account::ListAllUsers(&userCount, uids, nn::account::UserCountMax));

    for (int i = 0; i < userCount; i++)
    {
        nn::account::NetworkServiceAccountManager manager;

        if (nn::account::GetNetworkServiceAccountManager(&manager, uids[i]).IsFailure())
        {
            continue;
        }

        // 2KB あるのでスタックサイズに注意。
        Bit8 buffer[nn::account::RequiredBufferSizeForCachedNintendoAccountInfo] = {};

        nn::account::CachedNintendoAccountInfoForSystemService accountInfo;

        if (manager.LoadCachedNintendoAccountInfo(&accountInfo, buffer, sizeof (buffer)).IsFailure())
        {
            continue;
        }

        size_t size;
        const char* country = accountInfo.GetCountry(&size);

        if (size == 3)
        {
            if (actualCount < count)
            {
                nn::util::Strlcpy(outCountries[actualCount++].value, country, 3);
            }
        }
        else
        {
            NN_DETAIL_NEWS_INFO("[news] InvalidCountry: %s\n", country);
        }
    }

    *outCount = actualCount;
}

}}}}}
