﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/netdiag/netdiag_GlobalIpAddressApi.h>
#include <nn/netdiag/netdiag_GlobalIpAddressTypes.h>
#include <nn/netdiag/netdiag_Result.h>
#include <nn/netdiag/detail/netdiag_GlobalIpAddress.h>

namespace nn { namespace netdiag {

Result GetGlobalIpAddress( GlobalIpAddress* pGlobalIpAddress ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pGlobalIpAddress );
    return detail::GetGlobalIpAddress( pGlobalIpAddress );
}

void InterruptGetGlobalIpAddress() NN_NOEXCEPT
{
    detail::InterruptGetGlobalIpAddress();
}

}} // nn::netdiag
