﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.os
{
    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/os/os_EventCommon.h>")]
    public struct EventClearMode
    {
    }
}

namespace nn.mmnv
{
    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/mmnv/mmnv_Types.h>")]
    public struct Module
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/mmnv/mmnv_Types.h>")]
    public struct Priority
    {
    }
}

namespace nn.mmnv
{
    [CppRefPath(@"<nn/mmnv/sfdl/mmnv.sfdl.h>")]
    public interface IRequest : IServiceObject
    {
        [MethodId(0)]
        Result Initialize(Module moduleId, Priority priority, nn.os.EventClearMode eventClearMode);

        [MethodId(1)]
        Result Finalize(Module moduleId);

        [MethodId(2)]
        Result SetAndWait(Module moduleId, uint32_t min, uint32_t max);

        [MethodId(3)]
        Result Get(Out<uint32_t> setting, Module moduleId);

        [MethodId(4)]
        Result InitializeById(Out<int32_t> requestId, Module moduleId, Priority priority, nn.os.EventClearMode eventClearMode);

        [MethodId(5)]
        Result FinalizeById(int32_t requestId);

        [MethodId(6)]
        Result SetAndWaitById(int32_t requestId, uint32_t min, uint32_t max);

        [MethodId(7)]
        Result GetById(Out<uint32_t> setting, int32_t requestId);
    }

}
