﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "mmnv_RequestImpl.h"
#include "mmnv_RequestManager.h"
#include <nn/result/result_HandlingUtility.h>

#include "mmnv_Log.h"

namespace nn     {
namespace mmnv   {
namespace server {
namespace        {
    RequestManager g_RequestManager;
}

nn::Result RequestImpl::Initialize(Module moduleId, Priority priority, nn::os::EventClearMode eventClearMode) NN_NOEXCEPT
{
    NN_UNUSED(priority);

    // multimedia に関係のないモジュールが指定されている場合は何もせずに処理を抜ける。
    if ( moduleId != nn::mmnv::Module_Emc && moduleId != nn::mmnv::Module_Nvdec
         && moduleId != nn::mmnv::Module_Nvenc && moduleId != nn::mmnv::Module_Nvjpg )
    {
        // TODO: 適切な mmvn Result を用意する。
        return nn::ResultSuccess();
    }
    // fgm::Request インスタンスを作成し、初期化を実行する。自分自身をリストに登録する。
    return g_RequestManager.InitializeRequest(moduleId, eventClearMode, this);
}

nn::Result RequestImpl::Finalize(Module moduleId) NN_NOEXCEPT
{
    return g_RequestManager.FinalizeRequest(moduleId);
}

nn::Result RequestImpl::SetAndWait(Module moduleId, uint32_t min, uint32_t max) NN_NOEXCEPT
{
    return g_RequestManager.SetAndWait(moduleId, min, max);
}

nn::Result RequestImpl::Get(nn::sf::Out<uint32_t> setting, Module moduleId) NN_NOEXCEPT
{
    std::uint32_t current;
    nn::Result result = g_RequestManager.Get(&current, moduleId);
    *setting = current;
    return result;
}

nn::Result RequestImpl::InitializeById(
    nn::sf::Out<std::int32_t> requestId,
    nn::mmnv::Module moduleId,
    nn::mmnv::Priority priority,
    nn::os::EventClearMode eventClearMode) NN_NOEXCEPT
{
    NN_UNUSED(priority);

    // multimedia に関係のないモジュールが指定されている場合は何もせずに処理を抜ける。
    if ( moduleId != nn::mmnv::Module_Emc && moduleId != nn::mmnv::Module_Nvdec
         && moduleId != nn::mmnv::Module_Nvenc && moduleId != nn::mmnv::Module_Nvjpg )
    {
        // TODO: 適切な mmvn Result を用意する。
        return nn::ResultSuccess();
    }
    // fgm::Request インスタンスを作成し、初期化を実行する。自分自身をリストに登録する。
    return g_RequestManager.AcquireRequestId(&(*requestId), moduleId, eventClearMode, this);
}

nn::Result RequestImpl::FinalizeById(std::int32_t requestId) NN_NOEXCEPT
{
    return g_RequestManager.ReleaseRequestId(requestId);
}

nn::Result RequestImpl::SetAndWaitById(std::int32_t requestId, std::uint32_t min, std::uint32_t max) NN_NOEXCEPT
{
    return g_RequestManager.SetAndWait(requestId, min, max);
}

nn::Result RequestImpl::GetById(nn::sf::Out<std::uint32_t> setting, std::int32_t requestId) NN_NOEXCEPT
{
    std::uint32_t current;
    nn::Result result = g_RequestManager.Get(&current, requestId);
    *setting = current;
    return result;
}

RequestImpl::RequestImpl()
{
}

RequestImpl::~RequestImpl()
{
    // このインスタンスがこれまでに確保していたリソースを全て解放する
    g_RequestManager.ReleaseOwnRequestIds(this);
    g_RequestManager.ReleaseOwnRequestIdsForCompatibility(this);
}

}}}

