﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>

#define NN_MMNV_LOG(...) NN_SDK_LOG("[mmnv]" __VA_ARGS__)

// エラーログ
#define NN_MMNV_LOG_ERR(...) NN_SDK_LOG("[mmnv][ERROR]" __VA_ARGS__)
// 警告ログ
#define NN_MMNV_LOG_WARN(...) NN_SDK_LOG("[mmnv][WARNING]" __VA_ARGS__)
// 実行ログ
#define NN_MMNV_LOG_INFO(...) NN_SDK_LOG("[mmnv]" __VA_ARGS__)

//---------------------
// Empty Definitions
//---------------------
#ifndef NN_MMNV_LOG
#define NN_MMNV_LOG(...)
#endif

#ifndef NN_MMNV_LOG_ERR
#define NN_MMNV_LOG_ERR(...)
#endif
#ifndef NN_MMNV_LOG_WARN
#define NN_MMNV_LOG_WARN(...)
#endif
#ifndef NN_MMNV_LOG_INFO
#define NN_MMNV_LOG_INFO(...)
#endif
