﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.mii.detail
{
    public interface IDatabaseService : IServiceObject
    {
        [MethodId(0)]
        Result IsUpdated(Out<bool>outIsUpdated, int sourceFlags);

        [MethodId(1)]
        Result IsFullDatabase(Out<bool>outIsFullDatabase);

        [MethodId(2)]
        Result GetCount(Out<int>outCount, int sourceFlags);

        [MethodId(3)]
        Result Get(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)]OutArray<CharInfoElement> outElements, int sourceFlags);

        [MethodId(4)]
        Result Get1(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)]OutArray<CharInfo> outElements, int sourceFlags);

        [MethodId(5)]
        Result UpdateLatest(Out<CharInfo> outInfo, CharInfo info, int sourceFlags);

        [MethodId(6)]
        Result BuildRandom(Out<CharInfo> outInfo, int age, int gender, int race);

        [MethodId(7)]
        Result BuildDefault(Out<CharInfo> outInfo, int index);

        [MethodId(8)]
        Result Get2(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)]OutArray<StoreDataElement> outElements, int sourceFlags);

        [MethodId(9)]
        Result Get3(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)]OutArray<StoreData> outElements, int sourceFlags);

        [MethodId(10)]
        Result UpdateLatest1(Out<StoreData> outStoreData, StoreData storeData, int sourceFlags);

        [MethodId(11)]
        Result FindIndex(Out<int>outIndex, CreateId id, bool enabledSpecialMii);

        [MethodId(12)]
        Result Move(int newIndex, CreateId id);

        [MethodId(13)]
        Result AddOrReplace(StoreData storeData);

        [MethodId(14)]
        Result Delete(CreateId id);

        [MethodId(15)]
        Result DestroyFile();

        [MethodId(16)]
        Result DeleteFile();

        [MethodId(17)]
        Result Format();

        [MethodId(18)]
        Result Import(InBuffer inBuffer);

        [MethodId(19)]
        Result Export(OutBuffer outBuffer);

        [MethodId(20)]
        Result IsBrokenDatabaseWithClearFlag(Out<bool> outIsBrokenDatabase);

        [MethodId(21)]
        Result GetIndex(Out<int> outIndex, CharInfo info);

        [MethodId(22)]
        Result SetInterfaceVersion(int version);

        [MethodId(23)]
        Result Convert(Out<CharInfo> outInfo, Ver3StoreData ver3StoreData);
    }
}
