﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/mii/detail/service/mii_ServiceCommon.h>
#include <nn/mii/detail/service/mii_ServiceProvider.h>

#include <nn/os.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/result/result_HandlingUtility.h>

#include <new>


namespace nn
{
namespace mii
{

namespace
{
    bool g_IsServerStarted = false;

    nn::util::TypedStorage<detail::ServiceProvider, sizeof(detail::ServiceProvider), NN_ALIGNOF(detail::ServiceProvider)> g_ServiceProviderStorage;
    detail::ServiceProvider* g_pServiceProvider = nullptr;

    nn::os::ThreadType m_ThreadType;
    static const size_t ThreadStackSize = 12 * 1024;
    NN_OS_ALIGNAS_THREAD_STACK char m_ThreadStackBuffer[ThreadStackSize];

    void ServerManagerThreadFunction(void* pContext) NN_NOEXCEPT
    {
        NN_UNUSED(pContext);
        NN_SDK_ASSERT_NOT_NULL(g_pServiceProvider);

        g_pServiceProvider->Start();
    }
}

nn::Result RegisterServer() NN_NOEXCEPT
{
    if (g_pServiceProvider == nullptr)
    {
        g_pServiceProvider = new(&g_ServiceProviderStorage) detail::ServiceProvider();
    }

    NN_RESULT_SUCCESS;
}

nn::Result StartServer() NN_NOEXCEPT
{
    if (!g_IsServerStarted)
    {
        NN_RESULT_DO(nn::os::CreateThread(&m_ThreadType, ServerManagerThreadFunction, nullptr, m_ThreadStackBuffer, sizeof(m_ThreadStackBuffer), NN_SYSTEM_THREAD_PRIORITY(mii, Main)));

        nn::os::SetThreadNamePointer(&m_ThreadType, NN_SYSTEM_THREAD_NAME(mii, Main));
        nn::os::StartThread(&m_ThreadType);

        g_IsServerStarted = true;
    }

    NN_RESULT_SUCCESS;
}

namespace detail
{

ServiceProvider* GetServiceProviderPointer() NN_NOEXCEPT
{
    return g_pServiceProvider;
}

}

}
}

