﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/mii/detail/service/mii_HipcServerManager.h>

#include <nn/mii/detail/service/mii_ServiceNames.h>
#include <nn/mii/detail/service/mii_ServiceProvider.h>
//#include <nn/mii/detail/service/mii_Capabilities.h>

#include <nn/lmem/lmem_ExpHeap.h>


namespace nn
{
namespace mii
{
namespace detail
{

#if 0
namespace
{
#if defined(NN_BUILD_CONFIG_OS_WIN)
    const Capabilities g_UserCapabilities = { true, true, true, true };
    const Capabilities g_AdminCapabilities = { true, true, true ,true };
    const Capabilities g_SystemCapabilities = { true, true, true, true };
#else
    const Capabilities g_UserCapabilities = { false, false, false, false };
    const Capabilities g_AdminCapabilities = { true, true, false, true };
    const Capabilities g_SystemCapabilities = { false, false, true, false };
#endif
}
#endif

HipcServerManager::SfExpHeapAllocator::SfExpHeapAllocator(nn::lmem::CreationOption option) NN_NOEXCEPT
{
    m_ExpHeapAllocator.Attach(nn::lmem::CreateExpHeap(m_Buffer, sizeof(m_Buffer), option));
}

nn::sf::ExpHeapAllocator* HipcServerManager::SfExpHeapAllocator::GetBase() NN_NOEXCEPT
{
    return &m_ExpHeapAllocator;
}

HipcServerManager::HipcServerManager(ServiceProvider* pServiceProvider) NN_NOEXCEPT
    : m_SfExpHeapAllocator(nn::lmem::CreationOption_NoOption),
      m_UserStaticService(pServiceProvider, m_SfExpHeapAllocator.GetBase(), false),
      m_EditorStaticService(pServiceProvider, m_SfExpHeapAllocator.GetBase(), true),
      m_ImageDatabaseStaticService(pServiceProvider)
{
#if NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
    RegisterObjectForPort(m_UserStaticService.GetShared(), SessionCountMaxForUser, UserServiceName);
    RegisterObjectForPort(m_EditorStaticService.GetShared(), SessionCountMaxForEditor, EditorServiceName);
    RegisterObjectForPort(m_ImageDatabaseStaticService.GetShared(), SessionCountMaxForImageUserService, ImageDatabaseServiceName);

    Start();
#endif
}

HipcServerManager::~HipcServerManager() NN_NOEXCEPT
{
}

}
}
}
