﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/lm/detail/lm_ILogService.h>
#include "impl/lm_LogServiceImpl.h"

namespace nn { namespace lm {

namespace {
    struct LogServiceAllocatorTag;
    typedef sf::ExpHeapStaticAllocator<16 * 1024, LogServiceAllocatorTag> LogServiceAllocator;

    class LogServiceAllocatorInitializer
    {
    public:
        LogServiceAllocatorInitializer() NN_NOEXCEPT
        {
            LogServiceAllocator::Initialize(lmem::CreationOption_NoOption);
        }
    };
}

sf::SharedPointer<ILogService> CreateLogServiceByDfc() NN_NOEXCEPT
{
    NN_FUNCTION_LOCAL_STATIC(LogServiceAllocatorInitializer, s_LogServiceAllocatorInitializer);
    NN_UNUSED(s_LogServiceAllocatorInitializer);

    return sf::ObjectFactory<LogServiceAllocator::Policy>::CreateSharedEmplaced<lm::ILogService, lm::impl::LogServiceImpl>();
}

}} // nn::lm
