﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_Types.h>
#include <nn/lm/detail/lm_ILogService.h>

namespace nn { namespace lm {
    #if defined(NN_BUILD_CONFIG_OS_HORIZON)
    nn::sf::SharedPointer<ILogService> CreateLogServiceByHipc() NN_NOEXCEPT;
    #else
    nn::sf::SharedPointer<ILogService> CreateLogServiceByDfc() NN_NOEXCEPT;
    #endif
}}

namespace nn { namespace lm {namespace detail {

class ShimLibraryGlobal
{
public:
    static ShimLibraryGlobal& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(ShimLibraryGlobal, s_Instance);
        return s_Instance;
    }

private:
    ShimLibraryGlobal() NN_NOEXCEPT
    {
    #if defined(NN_BUILD_CONFIG_OS_HORIZON)
        auto service = CreateLogServiceByHipc();
    #else
        auto service = CreateLogServiceByDfc();
    #endif

        nn::sf::SharedPointer<ILogger> pointer;
        NN_ABORT_UNLESS_RESULT_SUCCESS(service->OpenLogger(&pointer, 0));
        m_Logger = pointer.Detach();
    }

public:
    ~ShimLibraryGlobal() NN_NOEXCEPT
    {
        nn::sf::ReleaseSharedObject(m_Logger);
    }

    ILogger* GetLogger() NN_NOEXCEPT
    {
        return m_Logger;
    }

private:
    ILogger* m_Logger;
};

}}} // nn::lm::detail
