﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_Types.h>
#include <nn/lm/detail/lm_ILogGetter.h>

namespace nn { namespace lm {
    #if defined(NN_BUILD_CONFIG_OS_HORIZON)
    nn::sf::SharedPointer<ILogGetter> CreateLogGetterByHipc() NN_NOEXCEPT;
    #else
    nn::sf::SharedPointer<ILogGetter> CreateLogGetterByDfc() NN_NOEXCEPT;
    #endif
}}

namespace nn { namespace lm {namespace detail {

class ShimLibraryForLogGetter
{
public:
    static ShimLibraryForLogGetter& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(ShimLibraryForLogGetter, s_Instance);
        return s_Instance;
    }

private:
    ShimLibraryForLogGetter() NN_NOEXCEPT
    {
    #if defined(NN_BUILD_CONFIG_OS_HORIZON)
        auto service = CreateLogGetterByHipc();
    #else
        auto service = CreateLogGetterByDfc();
    #endif

        m_LogGetter = service.Detach();
    }

public:
    ~ShimLibraryForLogGetter() NN_NOEXCEPT
    {
        nn::sf::ReleaseSharedObject(m_LogGetter);
    }

    ILogGetter* GetLogger() NN_NOEXCEPT
    {
        return m_LogGetter;
    }

private:
    ILogGetter* m_LogGetter;
};

}}} // nn::lm::detail
