﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn
{
    [CppRefPath(@"<nn/nn_TimeSpan.h>")]
    [ExternalStruct(8, 8)]
    public struct TimeSpan { }
}

namespace nn.lbl
{
    [CppRefPath(@"<nn/lbl/lbl_Type.h>")]
    [ExternalStruct(12, 4)]
    public struct MappingCoefficient { }

    namespace detail
    {
        // 実操作を担当する LBL のセッションオブジェクト。
        [CppRefPath("\"lbl_ILblController.h\"")]
        public interface ILblController : IServiceObject
        {
            [MethodId(0)]
            void SaveCurrentSetting();

            [MethodId(1)]
            void LoadCurrentSetting();

            [MethodId(2)]
            void SetCurrentBrightnessSetting(float brightnessSetting);

            [MethodId(3)]
            float GetCurrentBrightnessSetting();

            [MethodId(4)]
            void ApplyCurrentBrightnessSettingToBacklight();

            [MethodId(5)]
            float GetBrightnessSettingAppliedToBacklight();

            [MethodId(6)]
            void SwitchBacklightOn(TimeSpan fadeInTime);

            [MethodId(7)]
            void SwitchBacklightOff(TimeSpan fadeOutTime);

            [MethodId(8)]
            int32_t GetBacklightSwitchStatus();

            [MethodId(9)]
            void EnableDimming();

            [MethodId(10)]
            void DisableDimming();

            [MethodId(11)]
            bool IsDimmingEnabled();

            [MethodId(12)]
            void EnableAutoBrightnessControl();

            [MethodId(13)]
            void DisableAutoBrightnessControl();

            [MethodId(14)]
            bool IsAutoBrightnessControlEnabled();

            [MethodId(15)]
            void SetAmbientLightSensorValue(float sensorValue);

            [MethodId(16)]
            float GetAmbientLightSensorValue(Out<bool> pOutOverflowAlert);

            [MethodId(17)]
            void SetBrightnessReflectionDelayLevel(int32_t direction, float delayLevel);

            [MethodId(18)]
            float GetBrightnessReflectionDelayLevel(int32_t direction);

            [MethodId(19)]
            void SetCurrentBrightnessMapping(MappingCoefficient brightnessMapping);

            [MethodId(20)]
            void GetCurrentBrightnessMapping(Out<MappingCoefficient> brightnessMapping);

            [MethodId(21)]
            void SetCurrentAmbientLightSensorMapping(MappingCoefficient sensorMapping);

            [MethodId(22)]
            void GetCurrentAmbientLightSensorMapping(Out<MappingCoefficient> sensorMapping);

            [MethodId(23)]
            bool IsAmbientLightSensorAvailable();

            [MethodId(24)]
            void SetCurrentBrightnessSettingForVrMode(float brightnessSetting);

            [MethodId(25)]
            float GetCurrentBrightnessSettingForVrMode();

            [MethodId(26)]
            void EnableVrMode();

            [MethodId(27)]
            void DisableVrMode();

            [MethodId(28)]
            bool IsVrModeEnabled();
        }
    }
}
