﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   LBL ライブラリの自動輝度制御スレッド関連の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace lbl {
namespace server {

/**
 * @brief 自動輝度調整スレッドの動作を開始します。
 *
 * @pre         初期化されている必要があります。
 * @post        自動輝度調整スレッドの動作が開始されます。
 * @details     lbl サーバー向けの内部 API です。本 API の呼び出し後、自動輝度調整スレッドの動作を開始します。
 */
void StartAutoControlThread() NN_NOEXCEPT;

/**
 * @brief 自動輝度調整スレッドの動作を終了します。
 *
 * @pre         初期化されている必要があります。
 * @post        自動輝度調整スレッドの動作を終了します。
 * @details     lbl サーバー向けの内部 API です。本 API の呼び出し後、自動輝度調整スレッドの動作が停止します。
 */
void StopAutoControlThread() NN_NOEXCEPT;

} // server
} // lbl
} // nn


