﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/lbl/lbl_Type.h>

namespace nn { namespace lbl { namespace impl { namespace detail {

class Fader
{
    NN_DISALLOW_COPY(Fader);

public:
    Fader() NN_NOEXCEPT;

    //! バックライトの点灯/消灯の状態への遷移を開始する。
    void StartFade(bool isOn, nn::TimeSpan fadeTime) NN_NOEXCEPT;

    //! フェードイン/アウト時の遷移状態と低減率を更新し、最新の低減率を返す。
    float UpdateActiveBrightnessRatio() NN_NOEXCEPT;

    nn::lbl::BacklightSwitchStatus GetState() const NN_NOEXCEPT
    {
        return m_State;
    }

private:
    // 最後に適用された輝度設定値の比率の生値
    float m_LastRawBrightnessFadeRatio = 0.0f;

    // 点灯/消灯の遷移にかける時間
    nn::TimeSpan m_AssignedFadeTime = 0;

    // 最後に点灯/消灯の遷移状況を更新した時間
    nn::TimeSpan m_LastUpdatedTime = 0;

    // 現在の点灯/消灯の状態(遷移中かも含む)
    nn::lbl::BacklightSwitchStatus m_State = nn::lbl::BacklightSwitchStatus_OffWithStability;

    nn::os::Mutex m_Lock{ false };
};


}}}} // namespace nn::lbl::impl::detail
