﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>

#include "lbl_BacklightLowDriver.h"

namespace nn { namespace lbl { namespace impl { namespace detail {

class DeviceAccessorBacklight
{
    NN_DISALLOW_COPY(DeviceAccessorBacklight);

public:
    static const int MaxDuty = 255;

public:
    DeviceAccessorBacklight() NN_NOEXCEPT;

    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void SetDuty(int duty) NN_NOEXCEPT;
    void SetPower(bool enable) NN_NOEXCEPT;

private:
    int m_InitializeCount = 0;
    bool m_IsBacklightEnergyOn = false;
    nn::pwm::ChannelSession m_PwmSession;
    nn::gpio::GpioPadSession m_GpioSession;
    nn::os::Mutex m_Lock{ false };
};

}}}} // namespace nn::lbl::impl::detail
