﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>

#include "lbl_DeviceAccessorAls.h"

namespace nn { namespace lbl { namespace impl { namespace detail {

DeviceAccessorAls::DeviceAccessorAls(const SettingsHolder* pSettingsHolder) NN_NOEXCEPT
    : m_pSettingsHolder(pSettingsHolder)
{
}

void DeviceAccessorAls::Initialize() NN_NOEXCEPT
{
    ++m_InitializeCount;
    if ( m_InitializeCount == 1 )
    {
        if ( m_pSettingsHolder->IsAlsEnabled() )
        {
            m_IsDeviceOpen = true;
        }
    }
}

void DeviceAccessorAls::Finalize() NN_NOEXCEPT
{
    --m_InitializeCount;
    if ( m_InitializeCount == 0 )
    {
        m_IsDeviceOpen = false;
    }
}

void DeviceAccessorAls::UpdateIlluminance() NN_NOEXCEPT
{
    NN_SDK_ASSERT_GREATER(m_InitializeCount, 0);
}

nn::Result DeviceAccessorAls::HandleResultFromDriver(nn::Result result) NN_NOEXCEPT
{
    NN_SDK_ASSERT_GREATER(m_InitializeCount, 0);
    NN_RESULT_THROW(result);
}

}}}} // namespace nn::lbl::impl::detail
