﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>

#include "lbl_SettingsHolder.h"

namespace nn { namespace lbl { namespace impl { namespace detail {

class DeviceAccessorAls
{
    NN_DISALLOW_COPY(DeviceAccessorAls);

public:
    explicit DeviceAccessorAls(const SettingsHolder* pSettingsHolder) NN_NOEXCEPT;

    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;

    bool IsDeviceAccessible() const NN_NOEXCEPT
    {
        return m_IsDeviceOpen && !m_IsDeviceInError;
    }

    void UpdateIlluminance() NN_NOEXCEPT;

    float GetCurrentIlluminance(bool* pOutOverflowAlert) const NN_NOEXCEPT
    {
        if ( pOutOverflowAlert )
        {
            *pOutOverflowAlert = m_IsCurrentIlluminanceOverflown;
        }
        return m_CurrentIlluminance;
    }
    void SetCurrentIlluminanceForDebug(float illuminance) NN_NOEXCEPT
    {
        m_CurrentIlluminance = illuminance;
    }

private:
    nn::Result HandleResultFromDriver(nn::Result result) NN_NOEXCEPT;

private:
    int m_InitializeCount = 0;
    bool m_IsDeviceOpen = false;
    bool m_IsDeviceInError = false;
    bool m_IsCurrentIlluminanceOverflown = false;
    float m_CurrentIlluminance = 0.0f;
    nn::os::Mutex m_Lock{ false };

    //! 設定値へのアクセサ (参照のみ)
    const SettingsHolder* m_pSettingsHolder = nullptr;
};

}}}} // namespace nn::lbl::impl::detail
