﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   LBL ライブラリで使用するドライバスタブライブラリです。
 */

#pragma once

#include <nn/gpio/gpio_Type.h>
#include <nn/nn_TimeSpan.h>

/**
 * @brief GPIO のスタブです。
 */
namespace nn {
namespace gpio {

struct GpioPadSession
{
    void* _sessionHandle;
};

enum GpioPadName
{
    GpioPadName_PowLcdBlEn = 29, //!< POW_LCD_BL_EN
};

void Initialize() NN_NOEXCEPT;
void Finalize() NN_NOEXCEPT;
void OpenSession(GpioPadSession* pOutSession, GpioPadName pad) NN_NOEXCEPT;
void CloseSession(GpioPadSession* pSession) NN_NOEXCEPT;
void SetDirection(GpioPadSession* pSession, Direction direction) NN_NOEXCEPT;
void SetValue(GpioPadSession* pSession, GpioValue value) NN_NOEXCEPT;

} // gpio
} // nn

/**
 * @brief PWM のスタブです。
 */
namespace nn {
namespace pwm {

struct ChannelSession
{
    void* _sessionHandle;
};

enum ChannelName
{
    ChannelName_LcdBacklight = 2, //!< LCD のバックライト制御用チャンネルです。
};

void Initialize() NN_NOEXCEPT;
void Finalize() NN_NOEXCEPT;
void OpenSession(ChannelSession* pOutSession, ChannelName name) NN_NOEXCEPT;
void CloseSession(ChannelSession* pSession) NN_NOEXCEPT;
void SetPeriod(ChannelSession* pSession, nn::TimeSpan period) NN_NOEXCEPT;
void SetDuty(ChannelSession* pSession, int duty) NN_NOEXCEPT;
void SetEnabled(ChannelSession* pSession, bool enable) NN_NOEXCEPT;

} // pwm
} // nn
