﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "jit_PluginDiagnostics.h"

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/diag/detail/diag_DetailLog.h>
#include <nn/diag/detail/diag_DetailAssert.h>
#include <cstdio>
#include "jit_PluginFunctions.h"

namespace {

void (*g_VLogImpl)(const nn::diag::LogMetaData& logMetaData, const char* format, std::va_list formatArg);

}

namespace nn { namespace jit { namespace plugin {

void SetupPluginDiagnostics(uintptr_t (*lookupSymbol)(const char*)) NN_NOEXCEPT
{
    #define SET_SYMBOL(v, name) v = reinterpret_cast<decltype(v)>(lookupSymbol(name));

    SET_SYMBOL(g_VLogImpl, "_ZN2nn4diag6detail8VLogImplERKNS0_11LogMetaDataEPKcSt9__va_list");

    #undef SET_SYMBOL
}

}}}

namespace nn { namespace diag { namespace detail {

void VLogImpl(const LogMetaData& logMetaData, const char* format, std::va_list list) NN_NOEXCEPT
{
    if (g_VLogImpl)
    {
        g_VLogImpl(logMetaData, format, list);
    }
}

void LogImpl(const LogMetaData& logMetaData, const char* format, ...) NN_NOEXCEPT
{
    std::va_list list;
    va_start(list, format);
    VLogImpl(logMetaData, format, list);
    va_end(list);
}

void OnAssertionFailure(AssertionType assertionType, const char* condition, const char* functionName, const char* fileName, int lineNumber) NN_NOEXCEPT
{
    NN_UNUSED(assertionType);
    NN_UNUSED(condition);
    NN_UNUSED(functionName);
    NN_UNUSED(fileName);
    NN_UNUSED(lineNumber);
    NN_SDK_LOG("Assertion failed in plugin: %s(%d)\n", fileName, lineNumber);
    nn::jit::plugin::Panic();
}

void OnAssertionFailure(AssertionType assertionType, const char* condition, const char* functionName, const char* fileName, int lineNumber, const char* format, ...) NN_NOEXCEPT
{
    NN_UNUSED(format);
    OnAssertionFailure(assertionType, condition, functionName, fileName, lineNumber);
}

}}}
