﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/jit/jit_Api.h>
#include <nn/jitsrv/jitsrv_JitServices.sfdl.h>

namespace nn { namespace jit {

sf::SharedPointer<jitsrv::IJitService> GetJitService() NN_NOEXCEPT;

struct JitEnvironmentInfoImpl
{
    jitsrv::IJitEnvironment* p;
    JitEnvironmentInfo info;
};

JitHandle NewJitEnvironment() NN_NOEXCEPT;
void CloseJitEnvironment(JitHandle handle) NN_NOEXCEPT;
JitEnvironmentInfoImpl* GetImpl(JitHandle handle) NN_NOEXCEPT;

}}
