﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "jit_Library.h"

#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Abort.h>
#include <atomic>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/am/am_Shim.h>

namespace nn { namespace jit {

namespace {

sf::ShimLibraryObjectHolder<jitsrv::IJitService> g_JitService = NN_SF_SHIM_LIBRARY_OBJECT_HOLDER_INITIALIZER;
sf::SimpleAllInOneHipcClientManager<10> g_HipcClientManager = NN_SF_SIMPLE_ALL_IN_ONE_HIPC_CLIENT_MANAGER_INITIALIZER;

}

Result Initialize() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetApplicationFunctions()->PrepareForJit());
    return g_HipcClientManager.InitializeShimLibraryHolder(&g_JitService, "jit:u");
}

sf::SharedPointer<jitsrv::IJitService> GetJitService() NN_NOEXCEPT
{
    return g_JitService.GetObject();
}

void Finalize() NN_NOEXCEPT
{
    g_JitService.FinalizeHolder();
}

namespace {

JitEnvironmentInfoImpl g_JitEnvironmentInfoImpl;
std::atomic_bool g_Used;

}

JitEnvironmentInfoImpl* GetImpl(JitHandle handle) NN_NOEXCEPT;

JitHandle NewJitEnvironment() NN_NOEXCEPT
{
    auto old = g_Used.exchange(true);
    NN_ABORT_UNLESS(!old);
    return {&g_JitEnvironmentInfoImpl};
}

void CloseJitEnvironment(JitHandle handle) NN_NOEXCEPT
{
    NN_ABORT_UNLESS(g_Used);
    NN_ABORT_UNLESS(handle._p == &g_JitEnvironmentInfoImpl);
    g_JitEnvironmentInfoImpl = {};
    g_Used = false;
}

JitEnvironmentInfoImpl* GetImpl(JitHandle handle) NN_NOEXCEPT
{
    return static_cast<JitEnvironmentInfoImpl*>(handle._p);
}

}}
