﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.idle
{
    [ExternalStruct(56, 8)]
    [CppRefPath(@"<nn/idle/idle_SystemTypes.h>")]
    public struct HandlingContext
    {
    }
}

namespace nn.idle.detail
{
    [CppRefPath("<nn/idle/detail/idle_IPolicyManagerSystem.sfdl.h>")]
    interface IPolicyManagerSystem : IServiceObject
    {
        [MethodId(0)]
        Result GetAutoPowerDownEvent(Out<NativeHandle> handle);

        // 欠番
        // [MethodId(1)]
        // Result EnableIdleStateDetectionGlobally();

        // 欠番
        // [MethodId(2)]
        // Result DisableIdleStateDetectionGlobally();

        [MethodId(3)]
        Result SetHandlingContext(nn.idle.HandlingContext handlingContext);

        [MethodId(4)]
        Result LoadAndApplySettings();

        [MethodId(5)]
        Result ReportUserIsActive();
    }
}
