﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_Common.h>
#include <nn/os.h>

namespace nn { namespace idle { namespace server {

#if defined(NN_BUILD_CONFIG_OS_WIN)

    class BaseClock
    {
    public:
        void Initialize() NN_NOEXCEPT
        {
            m_BaseClock = 0;
        }
        nn::TimeSpan GetNow() NN_NOEXCEPT
        {
            return m_BaseClock;
        }

        void Proceed(const nn::TimeSpan& interval) NN_NOEXCEPT
        {
            m_BaseClock += interval;
        }

    private:
        // 仮想環境では、加速した時間経過を再現してテストできるようにするため GetSystemTick を使わず、この値を絶対時刻とする
        nn::TimeSpan m_BaseClock;
    };

#else

    class BaseClock
    {
    public:
        void Initialize() NN_NOEXCEPT
        {
        }

        nn::TimeSpan GetNow() NN_NOEXCEPT
        {
            return nn::os::ConvertToTimeSpan(nn::os::GetSystemTick());
        }

        void Proceed(const nn::TimeSpan& interval) NN_NOEXCEPT
        {
            NN_UNUSED(interval);
        }
    };

#endif


}}} // namespace nn::idle::server

