﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_DeviceCode.h>

#include <nn/i2c/driver/detail/dt/i2c_DeviceCodeNodeParser.h>
#include <nn/i2c/driver/i2c_I2cDeviceProperty.h>
#include <nn/i2c/driver/i2c_II2cDriver.h>

namespace nn { namespace i2c { namespace driver { namespace detail {

void InitializeDrivers() NN_NOEXCEPT;

void RegisterDriver(II2cDriver* pDriver) NN_NOEXCEPT;
nn::Result RegisterDeviceCodeNodeParser(nn::i2c::driver::detail::dt::IDeviceCodeNodeParser* pParser) NN_NOEXCEPT;
nn::Result RegisterDeviceCode(nn::DeviceCode deviceCode, I2cDeviceProperty* pDevice) NN_NOEXCEPT;

II2cDriver::List& GetDriverList() NN_NOEXCEPT;
nn::Result FindDevice(I2cDeviceProperty** ppOutDevice, nn::DeviceCode deviceCode) NN_NOEXCEPT;
nn::Result FindDeviceByBusIndexAndAddress(I2cDeviceProperty** ppOutDevice, int busIndex, Bit16 address) NN_NOEXCEPT;

}}}} // nn::i2c::driver::detail
