﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_InterruptEvent.h>

namespace nn {
namespace i2c {
namespace driver {
namespace detail {

// ハンドルする割り込み番号の数
const int InterruptCountMax = 6;

// 割り込み番号テーブル
const nn::os::InterruptName InterruptNameI2c1  = 32 + 38; // TRM では Name が I2C となっている(1 は付いてないので注意)
const nn::os::InterruptName InterruptNameI2c2  = 32 + 84;
const nn::os::InterruptName InterruptNameI2c3  = 32 + 92;
const nn::os::InterruptName InterruptNameI2c4  = 32 + 120;
const nn::os::InterruptName InterruptNameI2c5  = 32 + 53;
const nn::os::InterruptName InterruptNameI2c6  = 32 + 63;
const nn::os::InterruptName InterruptNameTable[InterruptCountMax] =
{
    InterruptNameI2c1,   // I2C1
    InterruptNameI2c2,   // I2C2
    InterruptNameI2c3,   // I2C3
    InterruptNameI2c4,   // I2C4
    InterruptNameI2c5,   // I2C5
    InterruptNameI2c6,   // I2C6
};

const int PowerBusIdx = 4;

// デバイス設定情報を格納した構造体
const DeviceSetting DeviceSettings[] =
{
    // I2C1 に接続されたクラコン
    {
        I2cDevice::I2cDevice_ClassicController, // Device name
        0,                                      // Bus#
        0x52,                                   // Slave address
        AddressingMode_BitWidth7,               // Addressing mode
        SpeedMode_Standard,                     // Speed mode
        0,
        0
    },
    // Power management unit - Pmic
    {
        I2cDevice::I2cDevice_Max77620Pmic,
        4,
        0x3c,
        AddressingMode_BitWidth7,
        SpeedMode_Fast,
        0,
        0
    },
    // Audio codec
    {
        I2cDevice::I2cDevice_Alc5639,
        0,
        0x1c,
        AddressingMode_BitWidth7,
        SpeedMode_Standard,
        0,
        0
    },
    // Thermal Sensor
    {
        I2cDevice::I2cDevice_Tmp451,
        0,
        0x4c,
        AddressingMode_BitWidth7,
        SpeedMode_Standard,
        0,
        0
    },
    // ここにデバイスを追記してください。
};

const int DeviceSettingsLength = (sizeof(DeviceSettings) / sizeof(DeviceSettings[0]));

const int MaxBuses             = 6;         // [Ref1] 31.0 物理的なバス数は6つ

} // detail
} // driver
} // i2c
} // nn
