﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include <nn/nn_Common.h>

#include "i2c_TargetSpec.h"

namespace nn {
namespace i2c {
namespace driver {
namespace detail {

const int PowerBusIdx = -1;

// デバイス設定情報を格納した構造体
const DeviceSetting DeviceSettings[] =
{
    // クラコン
    {
        I2cDevice::I2cDevice_ClassicController,  // Device name
        2,                                       // Bus#
        0x52,                                    // Slave address
        AddressingMode_BitWidth7,                // Addressing mode
        SpeedMode_Fast,                          // Speed mode
        0,
        0
    },
    // ここにデバイスを追記してください。
};

const int      MaxBuses             = 3;         // 物理的なバス数

const int      DeviceSettingsLength = (sizeof(DeviceSettings)  / sizeof(DeviceSettings[0]));

} // detail
} // driver
} // i2c
} // nn
