﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/os/os_SdkMutex.h>

#include <nn/htclow/detail/htclow_InternalTypes.h>

#include "htclow_ChannelResource.h"
#include "../../util/htclow_FixedSizeMap.h"

namespace nn { namespace htclow { namespace server { namespace mux {

    // ChannelInternalType -> ChannnelResource の map
    class ChannelResourceMap
    {
        NN_DISALLOW_COPY(ChannelResourceMap);
        NN_DISALLOW_MOVE(ChannelResourceMap);

    public:
        static const int MaxChannelCount = 64;

        using MapType = util::FixedSizeMap<MaxChannelCount, detail::ChannelInternalType, int>;

        ChannelResourceMap() NN_NOEXCEPT
            : m_RetransmitEnabled(true)
        {
        }

        const MapType& GetMap() NN_NOEXCEPT
        {
            return m_Map;
        }

        Result AddChannel(detail::ChannelInternalType channel) NN_NOEXCEPT;

        Result RemoveChannel(detail::ChannelInternalType channel) NN_NOEXCEPT;

        bool Exists(detail::ChannelInternalType channel) const NN_NOEXCEPT;

        ChannelResource& GetChannelResource(int index) NN_NOEXCEPT;

        ChannelResource& GetChannelResource(detail::ChannelInternalType channel) NN_NOEXCEPT;

        ChannelResource& operator[](detail::ChannelInternalType channel) NN_NOEXCEPT
        {
            return GetChannelResource(channel);
        }

        void SetRetransmitEnabled(bool enabled) NN_NOEXCEPT
        {
            m_RetransmitEnabled = enabled;
        }

    private:
        using ChannelResourceStorage = nn::util::TypedStorage<ChannelResource, sizeof(ChannelResource), NN_ALIGNOF(ChannelResource)>;

        ChannelResourceStorage m_Storages[MaxChannelCount];
        bool m_StorageValid[MaxChannelCount];

        MapType m_Map;

        bool m_RetransmitEnabled;
    };

}}}}
