﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/htclow/detail/htclow_Log.h>

#include "htclow_Print.h"

//#define NN_DETAIL_HTCLOW_ENABLE_PRINT

namespace nn { namespace htclow { namespace server {

namespace {
    const char* GetPacketTypeString(PacketType packetType) NN_NOEXCEPT
    {
        switch(packetType)
        {
        case PacketType::Data:      return "Data";
        case PacketType::DataAck:   return "DataAck";
        case PacketType::Syn:       return "Syn";
        case PacketType::SynAck:    return "SynAck";
        case PacketType::Fin:       return "Fin";
        case PacketType::FinAck:    return "FinAck";
        default:                    return "Unknown";
        }
    }
}

void PrintReceivePacket(const PacketHeader& header) NN_NOEXCEPT
{
    auto packetTypeString = GetPacketTypeString(header.packetType);

    // for Release build
    NN_UNUSED(header);
    NN_UNUSED(packetTypeString);

#if defined(NN_DETAIL_HTCLOW_ENABLE_PRINT)
    NN_DETAIL_HTCLOW_TRACE("Receive packet. (type=%s, channel=%d:%d:%d, sequenceId=%lld)\n", packetTypeString, header.channel.moduleId, header.channel.reserved, header.channel.channelId, header.sequenceId);
#endif
}

void PrintSendPacket(const PacketHeader& header) NN_NOEXCEPT
{
    auto packetTypeString = GetPacketTypeString(header.packetType);

    // for Release build
    NN_UNUSED(header);
    NN_UNUSED(packetTypeString);

#if defined(NN_DETAIL_HTCLOW_ENABLE_PRINT)
    NN_DETAIL_HTCLOW_TRACE("Send packet. (type=%s, channel=%d:%d:%d, sequenceId=%lld)\n", packetTypeString, header.channel.moduleId, header.channel.reserved, header.channel.channelId, header.sequenceId);
#endif
}

void PrintIgnorePacket(const PacketHeader& header) NN_NOEXCEPT
{
    auto packetTypeString = GetPacketTypeString(header.packetType);

    // for Release build
    NN_UNUSED(header);
    NN_UNUSED(packetTypeString);

#if defined(NN_DETAIL_HTCLOW_ENABLE_PRINT)
    NN_DETAIL_HTCLOW_WARN("Ignore packet. (type=%s, channel=%d:%d:%d, sequenceId=%lld)\n", packetTypeString, header.channel.moduleId, header.channel.reserved, header.channel.channelId, header.sequenceId);
#endif
}

}}}
