﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

#include <nn/os.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_SdkMutex.h>

#include <nn/htclow/detail/htclow_DebugTypes.h>

#include "htclow_IDriver.h"

#if defined(NNT_DETAIL_HTCLOW_ENABLE_DEBUG_DRIVER)
#include "htclow_DebugDriver.h"
#endif

#if defined(NNT_DETAIL_HTCLOW_ENABLE_SOCKET_DRIVER)
#include "htclow_SocketDriver.h"
#endif

namespace nn { namespace htclow { namespace server { namespace driver {

class DriverManager
{
    NN_DISALLOW_COPY(DriverManager);
    NN_DISALLOW_MOVE(DriverManager);

public:
    DriverManager() NN_NOEXCEPT
        : m_pCurrentDriver(nullptr)
    {
    }

    nn::Result OpenDriver(detail::DriverType driverType) NN_NOEXCEPT;
    void CloseDriver() NN_NOEXCEPT;

    IDriver* GetCurrentDriver() NN_NOEXCEPT;

#if defined(NNT_DETAIL_HTCLOW_ENABLE_DEBUG_DRIVER)
    DebugDriver* GetDebugDriver() NN_NOEXCEPT
    {
        return &m_DebugDriver;
    }
#endif

    void Cancel() NN_NOEXCEPT
    {
        return m_pCurrentDriver->Cancel();
    }

private:
    // TODO: ドライバが同時に1つしかインスタンス化されないようにする (Phase 3 以降)
#if defined(NNT_DETAIL_HTCLOW_ENABLE_DEBUG_DRIVER)
    DebugDriver m_DebugDriver;
#endif
#if defined(NNT_DETAIL_HTCLOW_ENABLE_SOCKET_DRIVER)
    SocketDriver m_SocketDriver;
#endif

    // OpenDriver, CloseDriver の際に取得する mutex
    nn::os::SdkMutex m_Mutex;

    // 現在選択されている driver を示す。どのドライバも選択していない場合は nullptr になる。
    IDriver* m_pCurrentDriver;
};

}}}}
