﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>

namespace nn { namespace htcfs { namespace server {

const int64_t HtcfsProtocol = 1;

// 現在の実装が対応しているバージョンの最大値
const int16_t MaxVersion = 1;

enum class PacketCategory : int16_t
{
    Request = 0,
    Response = 1,
};

enum class PacketType : int16_t
{
    GetMaxProtocolVersion = 0x00,
    SetProtocolVersion = 0x01,
    GetEntryType = 0x10,
    OpenFile = 0x20,
    CloseFile = 0x21,
    GetPriorityForFile = 0x22,
    SetPriorityForFile = 0x23,
    CreateFile = 0x24,
    DeleteFile = 0x25,
    RenameFile = 0x26,
    FileExists = 0x27,
    ReadFile = 0x28,
    WriteFile = 0x29,
    FlushFile = 0x2a,
    GetFileTimeStamp = 0x2b,
    GetFileSize = 0x2c,
    SetFileSize = 0x2d,
    OpenDirectory = 0x30,
    CloseDirectory = 0x31,
    GetPriorityForDirectory = 0x32,
    SetPriorityForDirectory = 0x33,
    CreateDirectory = 0x34,
    DeleteDirectory = 0x35,
    RenameDirectory = 0x36,
    DirectoryExists = 0x37,
    ReadDirectory = 0x38,
    GetEntryCount = 0x39,
};

struct Header
{
    int16_t protocol;
    int16_t version;
    PacketCategory packetCategory;
    PacketType packetType;
    int64_t bodySize;
    int64_t param0;
    int64_t param1;
    int64_t param2;
    int64_t param3;
    int64_t param4;
    int64_t reserved;
};

NN_STATIC_ASSERT(sizeof(Header) == 64);

}}}
