﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <type_traits>
#include <new>

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/psc.h>

#include <nn/hdcp/server/hdcp_HdcpHipcServer.h>

#include "../detail/hdcp_ServiceType.h"
#include <nn/hdcp/detail/hdcp_IHdcpController.h>

#include "hdcp_HdcpControllerImpl.h"
#include "hdcp_CreateHdcpControllerByDfc.h"

namespace nn { namespace hdcp { namespace server {

namespace {


// HipcSimpleAllInOneServerManager は HIPC のサーバのポートとセッションを一元管理する。
class MyServerManager
    : public nn::sf::HipcSimpleAllInOneServerManager<30, 1>
{};

// 繰り返しのサーバの起動と終了が可能となるように placement new で初期化を行う。
// 繰り返しの起動と終了が必要ない場合には MyServerManager は直接配置してもよい。
std::aligned_storage<sizeof(MyServerManager), NN_ALIGNOF(MyServerManager)>::type g_MyServerManagerStorage;
MyServerManager* g_pMyServerManager;

}

void StartServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(!g_pMyServerManager);

    // MyServerManager オブジェクトのコンストラクト
    g_pMyServerManager = new (&g_MyServerManagerStorage) MyServerManager;

    // サービス名の登録とポートの初期化
    // sessionCountMax は、現時点では十分に大きな値を指定しておけばよい。
    // 現在はどのプロセスからアクセスしても 1つのマネージャーにアクセスされる
    auto sessionCountMax = 30;
    g_pMyServerManager->RegisterObjectForPort(CreateHdcpControllerByDfc(), sessionCountMax, detail::HdcpServiceName);

    // サーバマネージャの開始
    // ただし、実際のサーバ動作は、LoopAuto 関数等を呼び出すことで行う必要がある。
    g_pMyServerManager->Start();
}

void LoopServer(void* arg) NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pMyServerManager);
    NN_UNUSED(arg);
    g_pMyServerManager->LoopAuto();
}

void RequestStopServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pMyServerManager);

    // 処理ループの停止リクエストを送り、LoopAuto 関数を返す
    g_pMyServerManager->RequestStop();
}

void FinalizeServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pMyServerManager);

    // MyServerManager のデストラクト
    // 登録したサービスなどはここで登録が解除される。
    g_pMyServerManager->~MyServerManager();
    g_pMyServerManager = nullptr;
}

}}}
