﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/result/result_HandlingUtility.h>

#include "../impl/hdcp_Switch.h"

#include <nn/hdcp/detail/hdcp_IHdcpController.h>
#include "../detail/hdcp_ServiceType.h"

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_NativeHandle.h>

#include "hdcp_HdcpControllerImpl.h"

namespace nn { namespace hdcp { namespace server {

// ここから各 HDCP API の内部実装
HdcpControllerImpl::HdcpControllerImpl() NN_NOEXCEPT
{
}

HdcpControllerImpl::~HdcpControllerImpl() NN_NOEXCEPT
{
}

Result HdcpControllerImpl::GetHdcpStateTransitionEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT
{
    nn::os::NativeHandle handle;
    NN_RESULT_DO(nn::hdcp::impl::GetHdcpStateTransitionEvent(&handle));
    *eventHandle = nn::sf::NativeHandle(handle, false);
    NN_RESULT_SUCCESS;
}

Result HdcpControllerImpl::GetHdcpAuthenticationState(nn::sf::Out<std::int32_t> outState) NN_NOEXCEPT
{
    nn::hdcp::HdcpAuthenticationState* pOutState = reinterpret_cast<nn::hdcp::HdcpAuthenticationState*>(outState.GetPointer());
    return nn::hdcp::impl::GetHdcpAuthenticationState(pOutState);
}

Result HdcpControllerImpl::SetCurrentHdcpMode(std::int32_t mode) NN_NOEXCEPT
{
    return nn::hdcp::impl::SetCurrentHdcpMode(static_cast<HdcpMode>(mode));
}

std::int32_t HdcpControllerImpl::GetCurrentHdcpMode() NN_NOEXCEPT
{
    return static_cast<std::int32_t>(nn::hdcp::impl::GetCurrentHdcpMode());
}

}}}
