﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hdcp/detail/hdcp_Log.h>

#include "hdcp_NvHdcpStub.h"

namespace nn { namespace hdcp { namespace impl { namespace detail {

namespace {

nvhdcp_state_transit_handler g_Handler;
bool g_IsPseudoErrorActivated;
HDCP_RET_ERROR g_PseudoError;
bool g_IsHdcpOpened;

}

NvHdcpStub NvHdcpStub::m_Instance;

NvHdcpStub::NvHdcpStub() NN_NOEXCEPT
{
    g_Handler = nullptr;
    g_IsHdcpOpened = false;
    g_IsPseudoErrorActivated = false;
    g_PseudoError = HDCP_RET_SUCCESS;
}

NvHdcpStub::~NvHdcpStub() NN_NOEXCEPT
{
}

NvHdcpStub& NvHdcpStub::GetInstance() NN_NOEXCEPT
{
    return NvHdcpStub::m_Instance;
}

HDCP_RET_ERROR NvHdcpStub::Open() NN_NOEXCEPT
{
    if (g_IsPseudoErrorActivated)
    {
        g_IsPseudoErrorActivated = false;
        return g_PseudoError;
    }
    g_IsHdcpOpened = true;
    return HDCP_RET_SUCCESS;
}

HDCP_RET_ERROR NvHdcpStub::Close() NN_NOEXCEPT
{
    if (g_IsPseudoErrorActivated)
    {
        g_IsPseudoErrorActivated = false;
        return g_PseudoError;
    }
    g_IsHdcpOpened = false;
    return HDCP_RET_SUCCESS;
}

HDCP_RET_ERROR NvHdcpStub::GetStatus() NN_NOEXCEPT
{
    if (g_IsPseudoErrorActivated)
    {
        g_IsPseudoErrorActivated = false;
        return g_PseudoError;
    }
    if (!g_IsHdcpOpened)
    {
        return HDCP_RET_UNSUCCESSFUL;
    }
    return HDCP_RET_SUCCESS;
}

HDCP_RET_ERROR NvHdcpStub::Enable(bool isEnabled) NN_NOEXCEPT
{
    NN_UNUSED(isEnabled);
    if (g_IsPseudoErrorActivated)
    {
        g_IsPseudoErrorActivated = false;
        return g_PseudoError;
    }
    if (!g_IsHdcpOpened)
    {
        return HDCP_RET_UNSUCCESSFUL;
    }
    return HDCP_RET_SUCCESS;
}

HDCP_RET_ERROR NvHdcpStub::SetTransitHandler(nvhdcp_state_transit_handler handler, void* context) NN_NOEXCEPT
{
    NN_UNUSED(context);
    if (g_IsPseudoErrorActivated)
    {
        g_IsPseudoErrorActivated = false;
        return g_PseudoError;
    }
    if (!g_IsHdcpOpened)
    {
        return HDCP_RET_UNSUCCESSFUL;
    }
    g_Handler = handler;
    return HDCP_RET_SUCCESS;
}

HDCP_RET_ERROR NvHdcpStub::InitializeAsyncEvent() NN_NOEXCEPT
{
    if (g_IsPseudoErrorActivated)
    {
        g_IsPseudoErrorActivated = false;
        return g_PseudoError;
    }
    if (!g_IsHdcpOpened)
    {
        return HDCP_RET_UNSUCCESSFUL;
    }
    return HDCP_RET_SUCCESS;
}

void NvHdcpStub::SetPseudoError(HDCP_RET_ERROR error) NN_NOEXCEPT
{
    g_PseudoError = error;
    g_IsPseudoErrorActivated = true;
}

void NvHdcpStub::SignalPseudoEvent(nvhdcp_state state, void* context) NN_NOEXCEPT
{
    if (g_Handler)
    {
        g_Handler(0, state, context);
    }
}

}}}} // namespace nn::hdcp::impl::detail
