﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_ThreadTypes.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/hdcp/hdcp_Type.h>
#include <nn/hdcp/hdcp_Result.h>

#include "hdcp_NvHdcpBase.h"

namespace nn { namespace hdcp { namespace impl { namespace detail {

class HdcpCore
{
    NN_DISALLOW_COPY(HdcpCore);

private:
    uint32_t m_CurrentNvState;
    int64_t m_TimeoutMsec;
    nn::os::SystemEvent m_StateTransitionEvent;
    NvHdcpBase* m_pNvHdcp;
    nn::os::ThreadType m_TimeoutThread;
    nn::os::EventType m_TimeoutEvent;
    bool m_IsTimeoutThreadRunning;
    bool m_IsAuthenticationTimeout;

public:
    explicit HdcpCore() NN_NOEXCEPT;

    Result Open() NN_NOEXCEPT;
    void Close() NN_NOEXCEPT;
    Result GetCurrentState(HdcpAuthenticationState* state) NN_NOEXCEPT;
    Result SetHdcpConfig(HdcpMode mode) NN_NOEXCEPT;
    Result GetHdcpStateTransitionEvent(nn::os::NativeHandle* pOutEventHandle) NN_NOEXCEPT;
};

}}}} // namespace nn::hdcp::impl::detail
