﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SystemThreadDefinition.h> // For InterruptThread

#include <nn/gpio/detail/gpio_Log.h>
#include <nn/gpio/gpio_Result.h>

#include <nn/gpio/driver/gpio_DriverServiceApi.h>
#include <nn/gpio/driver/gpio_IGpioDriver.h>
#include <nn/ddsf/ddsf_IEventHandler.h>
#include <nn/gpio/driver/detail/dt/gpio_DeviceCodeNodeParser.h>

#include "detail/gpio_Core.h"

namespace nn {
namespace gpio {
namespace driver {

void RegisterDriver(IGpioDriver* pDriver) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pDriver);
    detail::RegisterDriver(pDriver);
}

void UnregisterDriver(IGpioDriver* pDriver) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pDriver);
    NN_SDK_REQUIRES(pDriver->IsLinkedToList(), "pDriver is not registered\n");
    detail::UnregisterDriver(pDriver);
}

void RegisterDeviceCodeNodeParser(nn::gpio::driver::detail::dt::IDeviceCodeNodeParser* pParser) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pParser);
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::RegisterDeviceCodeNodeParser(pParser));
}

nn::Result RegisterDeviceCode(nn::DeviceCode deviceCode, Pad* pPad) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pPad);
    return detail::RegisterDeviceCode(deviceCode, pPad);
}

bool UnregisterDeviceCode(nn::DeviceCode deviceCode) NN_NOEXCEPT
{
    return detail::UnregisterDeviceCode(deviceCode);
}

void RegisterInterruptHandler(nn::ddsf::IEventHandler* pHandler) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pHandler);
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::RegisterInterruptHandler(pHandler));
}

void UnregisterInterruptHandler(nn::ddsf::IEventHandler* pHandler) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pHandler);
    detail::UnregisterInterruptHandler(pHandler);
}

} // driver
} // gpio
} // nn
