﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/gpio/driver/detail/gpio_EventHolder.h>

namespace nn {
namespace gpio {
namespace driver {
namespace detail {

bool EventHolder::IsBoundEvent() const NN_NOEXCEPT
{
    if (m_pEvent != nullptr)
    {
        return true;
    }
    return false;
}

void EventHolder::AttachEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT
{
    m_pEvent = pEvent;
}

nn::os::SystemEventType* EventHolder::DetachEvent() NN_NOEXCEPT
{
    auto detached = m_pEvent;
    m_pEvent = nullptr;
    return detached;
}

nn::os::SystemEventType* EventHolder::GetSystemEvent() NN_NOEXCEPT
{
    return m_pEvent;
}

} // detail
} // driver
} // gpio
} // nn
