﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/gpio/driver/gpio_IGpioDriver.h>
#include <nn/gpio/driver/gpio_Pad.h>
#include <nn/ddsf/ddsf_IEventHandler.h>
#include <nn/gpio/driver/detail/dt/gpio_DeviceCodeNodeParser.h>

namespace nn {
namespace gpio {
namespace driver {
namespace detail {

void InitializeDrivers() NN_NOEXCEPT;
void FinalizeDrivers() NN_NOEXCEPT;
void RegisterDriver(IGpioDriver* pDriver) NN_NOEXCEPT;
void UnregisterDriver(IGpioDriver* pDriver) NN_NOEXCEPT;
nn::Result RegisterDeviceCodeNodeParser(nn::gpio::driver::detail::dt::IDeviceCodeNodeParser* pParser) NN_NOEXCEPT;
nn::Result RegisterDeviceCode(nn::DeviceCode deviceCode, Pad* pPad) NN_NOEXCEPT;
bool UnregisterDeviceCode(nn::DeviceCode deviceCode) NN_NOEXCEPT;
nn::Result RegisterInterruptHandler(nn::ddsf::IEventHandler* pHandler) NN_NOEXCEPT;
void UnregisterInterruptHandler(nn::ddsf::IEventHandler* pHandler) NN_NOEXCEPT;

IGpioDriver::List& GetDriverList() NN_NOEXCEPT;
nn::Result FindPad(Pad** ppOutPad, nn::DeviceCode deviceCode) NN_NOEXCEPT;
nn::Result FindPadByNumber(Pad** ppOutPad, int padNumber) NN_NOEXCEPT;

} // detail
} // driver
} // gpio
} // nn
