﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_DeviceCode.h>

#include <nn/gpio/driver/gpio_Lib.h>
#include <nn/gpio/driver/gpio_PadAccessor.h>
#include <nn/gpio/driver/gpio_PadAccessorDev.h>

namespace nn { namespace gpio { namespace driver {


void Initialize() NN_NOEXCEPT
{
}

void Finalize() NN_NOEXCEPT
{
}

void OpenSession(GpioPadSession* pOutSession, nn::gpio::GpioPadName pad) NN_NOEXCEPT
{
    NN_UNUSED(pOutSession);
    NN_UNUSED(pad);
}

nn::Result OpenSession(GpioPadSession* pOutSession, nn::DeviceCode pad) NN_NOEXCEPT
{
    NN_UNUSED(pOutSession);
    NN_UNUSED(pad);
    return nn::gpio::ResultDeviceNotFound();
}

void CloseSession(GpioPadSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
}


void SetDirection(GpioPadSession* pSession, nn::gpio::Direction direction) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(direction);
}

nn::gpio::Direction GetDirection(GpioPadSession* pSession ) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    return nn::gpio::Direction_Input;
}

void SetInterruptMode(GpioPadSession* pSession, nn::gpio::InterruptMode mode ) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(mode);
}

nn::gpio::InterruptMode GetInterruptMode(GpioPadSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    return nn::gpio::InterruptMode_AnyEdge;
}

void SetInterruptEnable(GpioPadSession* pSession, bool enable ) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(enable);
}

bool GetInterruptEnable(GpioPadSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    return false;
}

nn::gpio::InterruptStatus GetInterruptStatus(GpioPadSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    return nn::gpio::InterruptStatus_Inactive;
}

void ClearInterruptStatus(GpioPadSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
}

nn::gpio::GpioValue GetValue(GpioPadSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    return nn::gpio::GpioValue_Low;
}

void SetValue(GpioPadSession* pSession, nn::gpio::GpioValue value ) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(value);
}

void SetDebounceEnabled(GpioPadSession* pSession, bool isEnable) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(isEnable);
}

bool GetDebounceEnabled(GpioPadSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    return false;
}

void SetDebounceTime(GpioPadSession* pSession, int msecTime) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(msecTime);
}

int GetDebounceTime(GpioPadSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    return 0;
}

Result BindInterrupt(nn::os::SystemEventType* pEvent, GpioPadSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(pEvent);

    return nn::gpio::ResultUnknown();
}
void UnbindInterrupt(GpioPadSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
}

void OpenSessionForDev(GpioPadSession* pOutSession, int padNumber) NN_NOEXCEPT
{
    NN_UNUSED(pOutSession);
    NN_UNUSED(padNumber);
}

bool IsWakeEventActive(GpioPadName name) NN_NOEXCEPT
{
    NN_UNUSED(name);
    return false;
}

nn::Result IsWakeEventActive(bool* pOutIsActive, nn::DeviceCode name) NN_NOEXCEPT
{
    NN_UNUSED(pOutIsActive);
    NN_UNUSED(name);
    return nn::gpio::ResultDeviceNotFound();
}

void Suspend() NN_NOEXCEPT
{
}

void Resume() NN_NOEXCEPT
{
}

void SuspendLow() NN_NOEXCEPT
{
}

void ResumeLow() NN_NOEXCEPT
{
}

void SetInitialGpioConfig() NN_NOEXCEPT
{
}

void SetInitialWakePinConfig() NN_NOEXCEPT
{
}

WakeBitFlag GetWakeEventActiveFlagSet() NN_NOEXCEPT
{
    WakeBitFlag flag;
    flag.Reset();
    return flag;
}

void SetWakeEventActiveFlagSetForDebug(GpioPadName name, bool isEnabled) NN_NOEXCEPT
{
    NN_UNUSED(name);
    NN_UNUSED(isEnabled);
}

nn::Result SetWakeEventActiveFlagSetForDebug(nn::DeviceCode name, bool isEnabled) NN_NOEXCEPT
{
    NN_UNUSED(name);
    NN_UNUSED(isEnabled);
    return nn::gpio::ResultDeviceNotFound();
}

void SetWakePinDebugMode(WakePinDebugMode mode) NN_NOEXCEPT
{
    NN_UNUSED(mode);
}


}}}
