﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include "gpio_DdUtil.h"
#include "gpio_EventHolder-soc.tegra.h"

namespace nn {
namespace gpio {
namespace driver {
namespace detail {

bool PadEventHolder::IsBoundEvent() NN_NOEXCEPT
{
    if (m_pEvent != nullptr)
    {
        return true;
    }
    return false;
}

void PadEventHolder::DestroyEvent() NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_EventHolderMutex);
    NN_SDK_ASSERT_NOT_NULL(m_pEvent);
    nn::os::DestroySystemEvent(m_pEvent);
}

void PadEventHolder::AttachEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_EventHolderMutex);
    m_pEvent = pEvent;
}

void PadEventHolder::DetachEvent() NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_EventHolderMutex);
    m_pEvent = nullptr;
}

void PadEventHolder::SetInternalInterruptFlag(bool isEnable) NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_EventHolderMutex);
    m_IsInternalInterruptEnable = isEnable;
}

bool PadEventHolder::IsInternalInterruptEnable() const NN_NOEXCEPT
{
    return m_IsInternalInterruptEnable;
}

nn::os::SystemEventType* PadEventHolder::GetSystemEvent() NN_NOEXCEPT
{
    return m_pEvent;
}

int PadEventHolder::GetPadNumber() NN_NOEXCEPT
{
    return m_PadNumber;
}

} // detail
} // driver
} // gpio
} // nn
