﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account/account_Api.h>
#include <nn/fs/fs_SystemSaveDataPrivate.h>
#include <nn/fs/fs_Utility.h>

namespace nn { namespace fs {

    Result MountSystemSaveData(const char* name, SystemSaveDataId id, const nn::account::Uid& user) NN_NOEXCEPT
    {
        AssertCheckUid(user);
        return MountSystemSaveData(name, id, ConvertAccountUidToFsUserId(user));
    }

    Result CreateSystemSaveData(SystemSaveDataId id, const nn::account::Uid& user, int64_t size, int64_t journalSize, uint32_t flags) NN_NOEXCEPT
    {
        AssertCheckUid(user);
        return CreateSystemSaveData(id, ConvertAccountUidToFsUserId(user), size, journalSize, flags);
    }

    Result DeleteSystemSaveData(SystemSaveDataId id, const nn::account::Uid& user) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(user != nn::account::InvalidUid);
        return DeleteSystemSaveData(SaveDataSpaceId::System, id, ConvertAccountUidToFsUserId(user));
    }

}}
