﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_SaveDataTransferVersion2.h>
#include <nn/fs/fs_Utility.h>

namespace nn { namespace fs {

    Result SaveDataTransferManagerVersion2::OpenSaveDataFullImporter(std::unique_ptr<ISaveDataDivisionImporter>* outValue, const InitialDataVersion2& initialData, const account::Uid& uid, SaveDataSpaceId saveDataSpaceId) NN_NOEXCEPT
    {
        return OpenSaveDataFullImporter(outValue, initialData, ConvertAccountUidToFsUserId(uid), saveDataSpaceId);
    }

}}

