﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/friends_PlayHistory.h>
#include <nn/friends/detail/friends_ImplPlayHistory.h>

#define GET_IMPL() NN_DETAIL_FRIENDS_GET_IMPL(PlayHistory)
#define CONST_GET_IMPL() NN_DETAIL_FRIENDS_CONST_GET_IMPL(PlayHistory)

namespace nn { namespace friends {

PlayHistory::PlayHistory() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_CLEAR_IMPL();
}

nn::account::NetworkServiceAccountId PlayHistory::GetAccountId() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->accountId;
}

const PlayRecord& PlayHistory::GetPlayRecord() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->playRecord;
}

bool PlayHistory::HasNetworkServiceAccountId() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->hasNetworkServiceAccountId;
}

bool PlayHistory::IsLocalPlayed() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->isLocalPlayed;
}

bool PlayHistory::IsValid() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->isValid;
}

}}
