﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/friends_FriendRequest.h>
#include <nn/friends/friends_Result.h>
#include <nn/friends/detail/friends_ImplFriendRequest.h>
#include <nn/friends/detail/friends_ShimLibraryGlobal.h>
#include <nn/friends/detail/friends_ApiDetail.h>
#include <nn/nn_SdkAssert.h>

#define GET_IMPL() NN_DETAIL_FRIENDS_GET_IMPL(FriendRequest)
#define CONST_GET_IMPL() NN_DETAIL_FRIENDS_CONST_GET_IMPL(FriendRequest)

namespace nn { namespace friends {

FriendRequest::FriendRequest() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_CLEAR_IMPL();
}

RequestId FriendRequest::GetRequestId() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->requestId;
}

nn::account::NetworkServiceAccountId FriendRequest::GetAccountId() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->accountId;
}

const nn::account::Nickname& FriendRequest::GetNickname() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->nickname;
}

nn::Result FriendRequest::GetProfileImageUrl(Url* outUrl, ImageSize imageSize) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outUrl);

    if (CONST_GET_IMPL()->requestListType == RequestListType_Faced)
    {
        *outUrl = CONST_GET_IMPL()->profileImageUrl;
    }
    else
    {
        auto session = detail::ShimLibraryGlobal::GetInstance().GetSyncSession();

        NN_RESULT_DO(session->GetProfileImageUrl(outUrl, CONST_GET_IMPL()->profileImageUrl, static_cast<int32_t>(imageSize)));
    }

    NN_RESULT_SUCCESS;
}

RequestType FriendRequest::GetRequestType() const NN_NOEXCEPT
{
    return static_cast<RequestType>(CONST_GET_IMPL()->requestType);
}

RequestStatus FriendRequest::GetRequestStatus() const NN_NOEXCEPT
{
    return static_cast<RequestStatus>(CONST_GET_IMPL()->requestStatus);
}

const RouteInfo& FriendRequest::GetRouteInfo() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->routeInfo;
}

const ExternalApplicationCatalogId& FriendRequest::GetExternalApplicationCatalogId() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->routeInfoExtra.candidate.catalogId;
}

const MiiName& FriendRequest::GetMiiName() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->routeInfoExtra.nnid.miiName;
}

const MiiImageUrlParam& FriendRequest::GetMiiImageUrlParam() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->routeInfoExtra.nnid.miiImageUrlParam;
}

nn::Result FriendRequest::GetMiiImageUrl(Url* outUrl) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outUrl);

    if (CONST_GET_IMPL()->requestType == RequestType_3Ds || CONST_GET_IMPL()->requestType == RequestType_Nnid)
    {
        NN_RESULT_DO(detail::GetMiiImageUrl(outUrl, CONST_GET_IMPL()->routeInfoExtra.nnid.miiImageUrlParam));
    }
    else
    {
        outUrl->value[0] = '\0';
    }

    NN_RESULT_SUCCESS;
}

bool FriendRequest::IsRead() const NN_NOEXCEPT
{
    if (CONST_GET_IMPL()->requestListType == RequestListType_Received)
    {
        return CONST_GET_IMPL()->read;
    }
    else
    {
        return true;
    }
}

bool FriendRequest::IsValid() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->isValid;
}

}}
